# SIR program and RAS implementation
# Version: 17/12/2010
# CORE
# Author: Niel Hens
# source("C:/Niel/CENSTAT/BOOK/Data/Chapter18/SIR age-structured core.R")
##########################################################################
# RAS model with FOI
#--------------------
if (choice=="RASFOI"){
ODE = function(t, states, params)
   {
   S = states[  1:100]
   I = states[101:200]
   R = states[201:300]
   mu    = params[1:100]
   betas = matrix(params[101:10100],100,100)
   alpha.rate = params[10101]
   dS = - (foi+mu)*S     							# Susceptibles
   dI = +foi*S -(alpha.rate+mu)*I              				# Infection
   dR = +alpha.rate*I-mu*R                                   	# Immune
   list(c(dS,dI,dR))
   }

# initialisation
S  = I  = R  = rep(0, 100)
#I[]=0; I[]<-10
#S[]=cohort.size*exp(-cumsum(mu))-I[]
#R[]=0
I[]<-1/alpha.rate*foi*exp(-cumsum(foi))*cohort.size*exp(-cumsum(mu))
S[]<-(exp(-cumsum(foi)))*cohort.size*exp(-cumsum(mu))
R=cohort.size*exp(-cumsum(mu))-S-I
dS = dI = dR = rep(0, 100)
params=matrix(c(mu=mu,betas=betas,alpha.rate=alpha.rate))
states=c(S = S, I = I, R = R)
}

# RAS model with WAIFW matrix W2
#-------------------------------
if (choice=="RASWAIFWW2"){
ODE = function(t, states, params)
   {
   S = states[  1:100]
   I = states[101:200]
   R = states[201:300]
   mu    = params[1:100]
   alpha.rate = params[10101]
   dS = -(apply(W2*I,2,"sum")+mu)*S    			      # Susceptibles
   dI = +apply(W2*I,2,"sum")*S -(alpha.rate+mu)*I              # Infection
   dR = +alpha.rate*I-mu*R                                   	# Immune
   list(c(dS,dI,dR))
   }
# initialisation
S  = I  = R  = rep(0, 100)
#I[]=0; I[]<-50000
#S[]=cohort.size*exp(-cumsum(mu))-I[]
#R[]=0
I[]<-1/alpha.rate*foi*exp(-cumsum(foi))*cohort.size*exp(-cumsum(mu))
S[]<-(exp(-cumsum(foi)))*cohort.size*exp(-cumsum(mu))
R=cohort.size*exp(-cumsum(mu))-S-I
dS = dI = dR = rep(0, 100)
params=matrix(c(mu=mu,betas=betas,alpha.rate=alpha.rate))
states=c(S = S, I = I, R = R)
}

# RAS model with WAIFW matrix W3
#-------------------------------
if (choice=="RASWAIFWW3"){
ODE = function(t, states, params)
   {
   S = states[  1:100]
   I = states[101:200]
   R = states[201:300]
   mu    = params[1:100]
   alpha.rate = params[10101]
   dS = -(apply(W3*I,2,"sum")+mu)*S    			      # Susceptibles
   dI = +apply(W3*I,2,"sum")*S -(alpha.rate+mu)*I              # Infection
   dR = +alpha.rate*I-mu*R                                   	# Immune
   list(c(dS,dI,dR))
   }
# initialisation
S  = I  = R  = rep(0, 100)
#I[]=0; I[]<-50000
#S[]=cohort.size*exp(-cumsum(mu))-I[]
#R[]=0
I[]<-1/alpha.rate*foi*exp(-cumsum(foi))*cohort.size*exp(-cumsum(mu))
S[]<-(exp(-cumsum(foi)))*cohort.size*exp(-cumsum(mu))
R=cohort.size*exp(-cumsum(mu))-S-I
dS = dI = dR = rep(0, 100)
params=matrix(c(mu=mu,betas=betas,alpha.rate=alpha.rate))
states=c(S = S, I = I, R = R)
}

# RAS model with WAIFW matrix W4
#-------------------------------
if (choice=="RASWAIFWW4"){
ODE = function(t, states, params)
   {
   S = states[  1:100]
   I = states[101:200]
   R = states[201:300]
   mu    = params[1:100]
   alpha.rate = params[10101]
   dS = -(apply(W4*I,2,"sum")+mu)*S    			      # Susceptibles
   dI = +apply(W4*I,2,"sum")*S -(alpha.rate+mu)*I              # Infection
   dR = +alpha.rate*I-mu*R                                   	# Immune
   list(c(dS,dI,dR))
   }
# initialisation
S  = I  = R  = rep(0, 100)
#I[]=0; I[]<-50000
#S[]=cohort.size*exp(-cumsum(mu))-I[]
#R[]=0
I[]<-1/alpha.rate*foi*exp(-cumsum(foi))*cohort.size*exp(-cumsum(mu))
S[]<-(exp(-cumsum(foi)))*cohort.size*exp(-cumsum(mu))
R=cohort.size*exp(-cumsum(mu))-S-I
dS = dI = dR = rep(0, 100)
params=matrix(c(mu=mu,betas=betas,alpha.rate=alpha.rate))
states=c(S = S, I = I, R = R)
}

# RAS model with contact matrices
#---------------------------------
if (choice=="RAScontact"){
ODE = function(t, states, params)
   {
   S = states[  1:100]
   I = states[101:200]
   R = states[201:300]
   mu    = params[1:100]
   betas = matrix(params[101:10100],100,100)
   alpha.rate = params[10101]
   dS = -(apply(betas*I,2,"sum")+mu)*S    			      # Susceptibles
   dI = +apply(betas*I,2,"sum")*S -(alpha.rate+mu)*I              # Infection
   dR = +alpha.rate*I-mu*R                                   	# Immune
   list(c(dS,dI,dR))
   }
# initialisation
S  = I  = R  = rep(0, 100)
#I[]<-0.001*cohort.size*exp(-cumsum(mu))
#S[]=cohort.size*exp(-cumsum(mu))-I[]
#R[]=0
I[]<-1/alpha.rate*foi*exp(-cumsum(foi))*cohort.size*exp(-cumsum(mu))
S[]<-(exp(-cumsum(foi)))*cohort.size*exp(-cumsum(mu))
R=cohort.size*exp(-cumsum(mu))-S-I
dS = dI = dR = rep(0, 100)
params=matrix(c(mu=mu,betas=betas,alpha.rate=alpha.rate))
states=c(S = S, I = I, R = R)
}

# Output files
#--------------
fullout<-array(NA,dim=c(Tinit[2],resolution,301))

# Dynamic model runs
#--------------------
# Start loop
for (initrun in Tinit[1]:Tinit[2])
   {
   # Some starting parameters
	print(paste("Initialisation run : Year = ",as.character(initrun),sep=""))
	states = ifelse(states < tol, 0, states)   
   # moving everyone, one state forward
	if (initrun!=Tinit[1]){
	for (j in 99:1)
      	{
	      states[j+  1]= states[j    ]
      	states[j+101]= states[j+100]
	      states[j+201]= states[j+200]
	      }
	states[1]   = cohort.size 	# Completely susceptible at birth					
	states[101] = 0							
	states[201] = 0
	}
	#print(states[101:110])
   # Time steps determined by resolution
	times  = seq(0, 1, length=resolution)
	params = matrix(c(mu = mu, betas = betas, alpha.rate=alpha.rate))
   # Output of the system of ODEs
	out = as.data.frame(lsoda(states, times, ODE, params))
	states<-as.matrix(out[resolution,])[-1]
	#print(states[101:110])
	par(mfrow=c(1,4))
	tot<-c(as.matrix(out[resolution,2:101]))+c(as.matrix(out[resolution,102:201]))+c(as.matrix(out[resolution,202:301]))
	plot(c(as.matrix(out[resolution,2:101]))/tot,xlab="age",ylab="percentage susceptible",type="l",ylim=c(0,1),lwd=2)
	plot(c(as.matrix(out[resolution,102:201]))/tot,xlab="age",ylab="percentage infected",type="l",ylim=c(0,0.001),lwd=2)
	title(c("run",initrun))
	plot(c(as.matrix(out[resolution,202:301]))/tot,xlab="age",ylab="percentage recovered",type="l",ylim=c(0,1),lwd=2)
	plot(tot,xlab="age",ylab="percentage recovered",type="l",ylim=c(0,max(tot)),lwd=2)
   # Output matrices: S third dim: 2:101, I third dim: 102:201, R third dim: 202:301
	fullout[initrun,,]<-as.matrix(out)
}
# End loop


